﻿using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    partial class REGISTRANT_RETIREMENT : LINQEntityBase
    {
        const string TERMINATIONCODE = "w";
        const string TYPECODE = "a";
        public REGISTRANT_RETIREMENT(RetirementData emisInfo, int registrantId)
        {
            if (emisInfo != null)
            {
                REGISTRANT_ID = registrantId;
                RETIREMENT_BEGIN_DATE = emisInfo.retirementBeginDate;
                RETIREMENT_SERVICE_CODE = emisInfo.retirementServiceCode;
                RETIREMENT_TERMINATION_DATE = emisInfo.retirementTermDate;
                //set STD_RETIREMENT_TYPE_ID 
                var typeCode = emisInfo?.retirementTypeCode ?? TYPECODE;
                SetRetirementTypeIdFromTypeCode(typeCode);
                
                var terminationCode = emisInfo?.retirementTerminationReasonCode ?? TERMINATIONCODE;
                SetTermintationReasonIdFromReasonCode(terminationCode);
            }
        }
        public void SetRetirementTypeIdFromTypeCode(string code)
        {
            switch (code.ToLower())
            {
                case "a":
                    STD_RETIREMENT_TYPE_ID = (int)RetirementTypeCode.Mandatory;
                    break;
                case "b":
                    STD_RETIREMENT_TYPE_ID = (int)RetirementTypeCode.Voluntary;
                    break;
                case "c":
                    STD_RETIREMENT_TYPE_ID = (int)RetirementTypeCode.Fleet_Reserve;
                    break;
                case "d":
                    STD_RETIREMENT_TYPE_ID = (int)RetirementTypeCode.Temporary_Disability_Retirement_List;
                    break;
                case "e":
                    STD_RETIREMENT_TYPE_ID = (int)RetirementTypeCode.Permanent_Disability_Retirement_List;
                    break;
                case "f":
                    STD_RETIREMENT_TYPE_ID = (int)RetirementTypeCode.Title_III;
                    break;
                case "g":
                    STD_RETIREMENT_TYPE_ID = (int)RetirementTypeCode.Special_Act;
                    break;
                case "h":
                    STD_RETIREMENT_TYPE_ID = (int)RetirementTypeCode.Philippine_Scouts;
                    break;
            }
        }
        public void SetTermintationReasonIdFromReasonCode(string code)
        {
            switch (code.ToLower())
            {
                case "d":
                    STD_RETIREMENT_TERMINATION_REASON_ID = (int)RetirementTerminationReasonCode.Death;
                    break;
                case "f":
                    STD_RETIREMENT_TERMINATION_REASON_ID = (int)RetirementTerminationReasonCode.Invalid_Entry;
                    break;
                case "s":
                    STD_RETIREMENT_TERMINATION_REASON_ID = (int)RetirementTerminationReasonCode.Separation;
                    break;
                case "w":
                    STD_RETIREMENT_TERMINATION_REASON_ID = (int)RetirementTerminationReasonCode.Not_Applicable;
                    break;
            }
        }

    }
    public enum RetirementTypeCode
    {
        Mandatory = 1, //A
        Voluntary = 2, //B
        Fleet_Reserve = 3, //C
        Temporary_Disability_Retirement_List = 4, //D
        Permanent_Disability_Retirement_List = 5, //E
        Title_III = 6, //F
        Special_Act = 7, //G
        Philippine_Scouts = 8 //H
    }
    public enum RetirementTerminationReasonCode
    {
        Death = 1, //D
        Invalid_Entry = 2, //F
        Separation = 3, //S
        Not_Applicable = 4, //W
    }

}
